import pandas as pd  
from sklearn.preprocessing import LabelEncoder 
import pickle 
from decision_company import read_csv_file, create_label_encoder, fit_transform_label_encoder, col_assign_val
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Apply Label Encoding to 'savings_status' and 'employment'  
le_savings_status = create_label_encoder()  
le_employment = create_label_encoder()  
  
col_assign_val(data_for_clustering, 'savings_status', fit_transform_label_encoder(le_savings_status, data_for_clustering['savings_status']))  
col_assign_val(data_for_clustering, 'employment', fit_transform_label_encoder(le_employment, data_for_clustering['employment']))

print("data_for_clustering:\n", data_for_clustering)    
pickle.dump(data_for_clustering,open("./ref_result/data_for_clustering.pkl","wb"))